<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:hhmap="urn:WebWorks-HTMLHelp-Map-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwfiles wwdoc wwsplits wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Links -->
 <!--        -->
 <xsl:variable name="GlobalLinksPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLinksType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLinks" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLinksPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <xsl:variable name="VarCustomMapFile" select="wwprojext:GetFormatSetting('htmlhelp-custom-map-file')" />

   <xsl:if test="string-length($VarCustomMapFile) = 0">

    <!-- Iterate input documents -->
    <!--                         -->
    <xsl:for-each select="$GlobalInput[1]">
     <!-- Groups -->
     <!--        -->
     <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
     <xsl:value-of select="wwprogress:Start(count($VarProjectGroups))" />
     <xsl:for-each select="$VarProjectGroups">
      <xsl:variable name="VarProjectGroup" select="." />

      <xsl:value-of select="wwprogress:Start(1)" />

      <!-- Access splits -->
      <!--               -->
      <xsl:for-each select="$GlobalFiles[1]">

       <xsl:value-of select="wwprogress:Start(1)" />

       <xsl:variable name="VarFilesNameInfo" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))" />
       <xsl:for-each select="$VarFilesNameInfo[1]">
        <xsl:variable name="VarSplitsFileInfo" select="." />

        <xsl:value-of select="wwprogress:Start(1)" />

        <!-- Load splits -->
        <!--             -->
        <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarSplitsFileInfo/@path)" />

        <!-- Iterate input documents -->
        <!--                         -->
        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:value-of select="wwprogress:Start(1)" />

         <xsl:variable name="VarFilesDocumentNodes" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDependsType))" />

         <!-- Output path -->
         <!--             -->
         <xsl:variable name="VarPath">
          <xsl:for-each select="$VarSplits[1]">
           <xsl:value-of select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitFileType))/@path"/>
          </xsl:for-each>
         </xsl:variable>

         <!-- Call template -->
         <!--               -->
         <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $GlobalProject/wwproject:Project/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
         <xsl:if test="not($VarUpToDate)">
          <xsl:variable name="VarResultAsXML">
           <xsl:call-template name="HtmlHelpMapFile">
            <xsl:with-param name="ParamSplits" select="$VarSplits" />
            <xsl:with-param name="ParamLinks" select="$GlobalLinks" />
            <xsl:with-param name="ParamFilesDocumentNodes" select="$VarFilesDocumentNodes" />
           </xsl:call-template>
          </xsl:variable>
          <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
          <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
          <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, $VarEncoding, 'text')" />
         </xsl:if>

         <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
          <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
          <wwfiles:Depends path="{$GlobalLinksPath}" checksum="{wwfilesystem:GetChecksum($GlobalLinksPath)}" groupID="" documentID="" />
          <wwfiles:Depends path="{$VarSplitsFileInfo/@path}" checksum="{$VarSplitsFileInfo/@checksum}" groupID="{$VarSplitsFileInfo/@groupID}" documentID="{$VarSplitsFileInfo/@documentID}" />

          <xsl:for-each select="$VarFilesDocumentNodes">
           <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
          </xsl:for-each>
         </wwfiles:File>

         <xsl:value-of select="wwprogress:End()" />
        </xsl:for-each>

        <xsl:value-of select="wwprogress:End()" />
       </xsl:for-each>

       <xsl:value-of select="wwprogress:End()" />
      </xsl:for-each>

      <xsl:value-of select="wwprogress:End()" />
     </xsl:for-each>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="HtmlHelpMapFile">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamFilesDocumentNodes" />

  <xsl:variable name="VarMapItemsAsXML">
   <hhmap:Map version="1.0">
    <xsl:for-each select="$ParamFilesDocumentNodes">
     <xsl:variable name="VarDocument" select="." />
     <xsl:variable name="VarLinkFiles" select="$ParamLinks/wwlinks:Links/wwlinks:File[@documentID = $VarDocument/@documentID]" />

     <xsl:for-each select="$VarLinkFiles">
      <xsl:variable name="VarLinkFile" select="." />

      <xsl:variable name="VarTopicAliasParagraphs" select="$VarLinkFile/wwlinks:Paragraph[string-length(@topic) &gt; 0]" />

      <xsl:for-each select="$VarTopicAliasParagraphs">
       <xsl:variable name="VarTopicParagraph" select="." />
       <hhmap:MapItem topic="{$VarTopicParagraph/@topic}" title="{$VarLinkFile/@title}" />
      </xsl:for-each>
     </xsl:for-each>
    </xsl:for-each>
   </hhmap:Map>
  </xsl:variable>

  <xsl:variable name="VarMapItems" select="msxsl:node-set($VarMapItemsAsXML)/hhmap:Map/hhmap:MapItem" />

  <xsl:for-each select="$VarMapItems">
   <xsl:variable name="VarMapItem" select="." />
   <xsl:text>#define </xsl:text>
   <xsl:value-of select="$VarMapItem/@topic"/>
   <xsl:text> </xsl:text>
   <xsl:value-of select="number(10000000) + (position() * 10)"/>
   <xsl:text> </xsl:text>
   <xsl:text>/* </xsl:text>
   <xsl:value-of select="$VarMapItem/@title" />
   <xsl:text> */</xsl:text>
   <xsl:text>
</xsl:text>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
